import random
import string
import requests
from rembg import remove
from PIL import Image
from io import BytesIO
from flask import Flask, request, jsonify

app = Flask(__name__)

# Function to generate a random string for the file name
def random_string(length=8):
    letters = string.ascii_lowercase
    return ''.join(random.choice(letters) for _ in range(length))

@app.route('/process_image', methods=['POST'])
def process_image():
    try:
        # Get the image URL from the form-data
        image_url = request.form.get('image_url')

        # Download the image from the URL
        response = requests.get(image_url)
        input_image = Image.open(BytesIO(response.content))

        # Remove the background
        output_image = remove(input_image)

        # Generate a random file name with the .png extension
        random_file_name = f"{random_string()}.png"

        # Create the output file path
        output_path = random_file_name

        # Save the output image
        output_image.save(output_path)

        return jsonify({"message": "Image processed successfully", "file_url": output_path})
    except Exception as e:
        return jsonify({"error": str(e)})

if __name__ == '__main__':
    app.run(debug=True)
